#!/bin/bash

# Pick ONE eval script (GPU models = qwen/llama, CPU model = gpt-4o). Comment/uncomment as needed
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
#SCRIPT_PATH="$SCRIPT_DIR/qwen_eval_web_aes_persona_static.py"
SCRIPT_PATH="$SCRIPT_DIR/llama_eval_web_aes_persona_static.py"
#SCRIPT_PATH="$SCRIPT_DIR/gpt_eval_web_aes_persona_static.py"

DATASET_PATH="$SCRIPT_DIR/../../website-aesthetics-datasets/rating-based-dataset/preprocess/test_list.csv"
OUT_PARENT="$SCRIPT_DIR/results_$(basename "$SCRIPT_PATH" .py)"
mkdir -p "$OUT_PARENT/logs"

# GPU settings (used for Qwen & Llama)
GPUS=(0 1 2 3 4 5 6 7)
MAX_JOBS_PER_GPU=1
TOTAL_JOBS=$((${#GPUS[@]} * MAX_JOBS_PER_GPU))

CPU_PARALLEL_JOBS=4

# Helpers -------------------------------------------------
run_gpu_job() {
  local s=$1; local o=$2; local start=$3; local end=$4; local gpu=$5
  CUDA_VISIBLE_DEVICES=$gpu nohup python -u "$s" \
    --start "$start" --end "$end" --output_dir "$o" \
    > "$o/logs/slice_${start}_${end}_gpu${gpu}.log" 2>&1 &
}
run_cpu_job() {
  local s=$1; local o=$2; local start=$3; local end=$4
  nohup python -u "$s" \
    --start "$start" --end "$end" --output_dir "$o" \
    > "$o/logs/slice_${start}_${end}.log" 2>&1 &
}

# Slice calc ----------------------------------------------
TOTAL_LINES=$(( $(wc -l < "$DATASET_PATH") - 1 ))
if [[ "$SCRIPT_PATH" == *gpt* ]]; then
  LINES_PER_JOB=$(((TOTAL_LINES + CPU_PARALLEL_JOBS - 1)/CPU_PARALLEL_JOBS))
else
  LINES_PER_JOB=$(((TOTAL_LINES + TOTAL_JOBS - 1)/TOTAL_JOBS))
fi

job=0; start_idx=0
while [ $start_idx -lt $TOTAL_LINES ]; do
  end_idx=$((start_idx + LINES_PER_JOB - 1)); [ $end_idx -ge $TOTAL_LINES ] && end_idx=$((TOTAL_LINES-1))

  if [[ "$SCRIPT_PATH" == *gpt* ]]; then
    run_cpu_job  "$SCRIPT_PATH" "$OUT_PARENT" $start_idx $end_idx
    ((job++)); (( job % CPU_PARALLEL_JOBS == 0 )) && wait
  else
    gpu=${GPUS[$((job % ${#GPUS[@]}))]}
    run_gpu_job "$SCRIPT_PATH" "$OUT_PARENT" $start_idx $end_idx $gpu
    ((job++)); (( job % TOTAL_JOBS == 0 )) && wait
  fi
  start_idx=$((end_idx+1))
done
wait

# Merge ----------------------------------------------------
python - <<PY
import glob, json, os
out_dir = "$OUT_PARENT"
merged=[]
for fp in sorted(glob.glob(os.path.join(out_dir, 'results_*_slice_*.json'))):
    try:
        with open(fp) as f: merged.extend(json.load(f))
    except Exception as e:
        print(f'WARN: {fp} -> {e}')
final=os.path.join(out_dir,'merged.json')
with open(final,'w') as f: json.dump(merged,f,indent=2)
print('Merged',len(merged),'records ->',final)
PY
